<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGalleryFeaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('gallery_features')) {
            Schema::create('gallery_features', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('gallery_id');
                $table->foreign('gallery_id')
                    ->references('id')->on('galleries')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');
                $table->string('featurable_type')->nullable()->default(null);
                $table->unique(['gallery_id', 'featurable_type']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gallery_features');
    }
}
