<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFeaturableFieldsToItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('items')) {
            Schema::table('items', function (Blueprint $table) {
                /*
                  Necesario construir manualmente para hacer posible null

                  Añadidos en orden invertido para permitir "after"
                 */
                $table->unsignedInteger('featurable_id')->nullable()->default(null)->after('priority');
                $table->string('featurable_type')->nullable()->after('priority');
                $table->index(['featurable_type', 'featurable_id']);
                $table->boolean('is_priority_fixed')->after('priority')->default(false);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('items', function (Blueprint $table) {
            $table->dropMorphs('featurable');
            $table->dropColumn('is_priority_fixed');
        });
    }
}
