<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUniquePriorityConstraintToItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('items')) {
            Schema::table('items', function (Blueprint $table) {
                $table->unique(['gallery_id', 'priority']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('items', function($table) {
            /*
              Esto es necesario porque MySQL tiene un bug: quita el FOREIGN KEY
             */
            $table->index('gallery_id', 'items_gallery_id_foreign');
        });

        Schema::table('items', function (Blueprint $table) {
            $table->dropUnique('items_gallery_id_priority_unique');
        });
    }
}
