<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldIsRoompricesListToTablePages extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('pages')) {
            Schema::table('pages', function (Blueprint $table) {
                $table->boolean('is_roomprices_list')
                    ->after('index')
                    ->nullable()
                    ->default(null);
                $table->unique(['site_id', 'is_roomprices_list']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
            ADVERTENCIA: Este rollback es destructivo, pues eliminará todas las
            asignaciones de páginas de reservación
         */
        Schema::table('pages', function($table) {
            /*
              Esto es necesario porque MySQL tiene un bug: quita el FOREIGN KEY
             */
            $sm = Schema::getConnection()->getDoctrineSchemaManager();
            $indexesFound = $sm->listTableIndexes('pages');

            if (!array_key_exists("pages_site_id_foreign", $indexesFound)) {
                $table->index('site_id', 'pages_site_id_foreign');
            }
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->dropUnique('pages_site_id_is_roomprices_list_unique');
            $table->dropColumn('is_roomprices_list');
        });
    }
}
