<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateCardsTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('card_translations')) {
            Schema::table('card_translations', function (Blueprint $table) {
                $table->string('title')->nullable()->change();
                $table->longText('body')->nullable()->change();
            });
        }
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('card_translations')) {
            Schema::table('card_translations', function (Blueprint $table) {
                $table->string('title')->change();
                $table->longText('body')->change();
            });
        }
    }
}
