<?php

use AvengersMG\MGCms2019\App\Cms\Users\User;
use AvengersMG\MGCms2019\Database\Seeds\RoleTableSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class RefactorizeRolesAndPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Actualizar roles actuales */
        Role::where('name', 'admin')->update(['name' => 'super_admin']);

        Role::where('name', 'reservations')->update(['name' => 'ecommerce']);

        /* Quitar permisos del caché */
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        /* Llamar al semillero */
        Artisan::call('db:seed', [
            '--class' => RoleTableSeeder::class,
            '--force' => true,
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
          ADVERTENCIA: El método no cambiará los permisos, sino que cambiará los nombres de los roles y eliminará el rol "admin"
        */
        Role::where('name', 'admin')->delete();

        /* Retornar nombres */
        Role::where('name', 'super_admin')->update(['name' => 'admin']);
        Role::where('name', 'ecommerce')->update(['name' => 'reservations']);

        /* Quitar permisos del caché */
        app()[PermissionRegistrar::class]->forgetCachedPermissions();
    }
}
