<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveTranslatableFieldsFromMediafilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('mediafiles')) {
            /* Eliminar los campos redundantes */
            Schema::table('mediafiles', function (Blueprint $table) {
                $table->dropColumn([
                    'locale',
                    'alt',
                    'title',
                    'description',
                    'link',
                ]);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /*
          Crear los campos perdidos.
          Para llenar correctamente todos los valores, es necesario
          correr el método down() de la migración
          "2019_06_25_224923_insert_values_into_mediafile_translations_table"
        */
        Schema::table('mediafiles', function (Blueprint $table) {
            /* Estándar: Inglés es el lenguaje predeterminado */
            $table->string('locale')->default('en');
            $table->string('alt')->nullable();
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('link')->nullable();
        });
    }
}
