<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class InsertValuesIntoMediafileTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $table_name = 'languages_' . time();

        /* Crear tabla temporal */
        Schema::create($table_name, function (Blueprint $table) {
            $table->string('locale_tag');
            $table->temporary();
        });

        /* Escribir idiomas disponibles en la tabla temporal */
        DB::table($table_name)->insert(
            collect(app()->make('translatable.locales')->all())->map(function($item){
                return ['locale_tag' => $item];
            })->all()
        );

        /* Poblar la tabla con los valores existentes */
        DB::insert('INSERT INTO
            `mediafile_translations`
                (
                    `mediafile_id`,
                    `locale`,
                    `alt`,
                    `title`,
                    `description`,
                    `link`,
                    `created_at`,
                    `updated_at`
                )
            SELECT DISTINCT
                `mediafiles`.`id` AS `mediafile_id`,
                `'. $table_name .'`.`locale_tag` AS `locale`,
                `mediafiles`.`alt`,
                `mediafiles`.`title`,
                `mediafiles`.`description`,
                `mediafiles`.`link`,
                `mediafiles`.`created_at`,
                `mediafiles`.`updated_at`
            FROM `mediafiles`
                INNER JOIN
                    `'. $table_name .'`
                        ON
                        (
                            (`'. $table_name .'`.`locale_tag` = `mediafiles`.`locale`)
                            OR
                            (`mediafiles`.`locale` = "both")
                        )
        ');

        /* Eliminar tabla temporal */
        Schema::dropIfExists($table_name);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $table_name = 'mediafile_translations_filter_' . time();

        /* Crear tabla temporal */
        Schema::create($table_name, function (Blueprint $table) {
            $table->unsignedInteger('id');
            $table->string('alt')->nullable();
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('link')->nullable();
            $table->string('locale');
            $table->temporary();
        });

        /*
          Poblar la tabla temporal con los valores filtrados existentes en
          la tabla `mediafile_translations`
         */
        DB::insert('INSERT INTO
            `'. $table_name .'`
                (
                    `id`,
                    `alt`,
                    `title`,
                    `description`,
                    `link`,
                    `locale`
                )
            SELECT DISTINCT
                `mediafile_translations`.`mediafile_id` AS `id`,
                `mediafile_translations`.`alt`,
                `mediafile_translations`.`title`,
                `mediafile_translations`.`description`,
                `mediafile_translations`.`link`,
                IF(
                    `mediafile_translations_quantity`.`quantity` > 1,
                    "both",
                    `mediafile_translations`.`locale`
                ) AS `locale`

            FROM
                        `mediafile_translations`
                    INNER JOIN
                        (
                            SELECT
                                `mediafile_translations`.`mediafile_id`,
                                COUNT(*) AS `quantity`
                            FROM
                              `mediafile_translations`
                            GROUP BY
                                `mediafile_translations`.`mediafile_id`
                        )
                        AS `mediafile_translations_quantity`
                    ON
                        (`mediafile_translations_quantity`.`mediafile_id` = `mediafile_translations`.`mediafile_id`)
        ');

        /*
          Actualizar la información de acuerdo con las
          traducciones obtenidas.

          NOTA: Por la naturaleza de la conversión, si un registro tiene
          más de una traducción y el registro original -antes de ejecutar
          up() de esta migración- tenía "both" en la columna
          `mediafiles`.`locale`, los registros de texto
          serán llenados con el PRIMER valor encontrado para el ID, aunque existan varios.
        */
        DB::update('UPDATE
            `mediafiles`,
            `'. $table_name .'`
        SET
            `mediafiles`.`alt` = `'. $table_name .'`.`alt`,
            `mediafiles`.`title` = `'. $table_name .'`.`title`,
            `mediafiles`.`description` = `'. $table_name .'`.`description`,
            `mediafiles`.`link` = `'. $table_name .'`.`link`,
            `mediafiles`.`locale` = `'. $table_name .'`.`locale`
        WHERE
            (`'. $table_name .'`.`id` = `mediafiles`.`id`)
        ');

        /* Eliminar tabla temporal */
        Schema::dropIfExists($table_name);
    }
}
