<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediafileTranslations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mediafile_translations')) {
            Schema::create('mediafile_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('mediafile_id');
                $table->foreign('mediafile_id')
                    ->references('id')->on('mediafiles')
                        ->onDelete('cascade')
                        ->onUpdate('cascade');
                $table->string('locale');
                $table->string('alt')->nullable();
                $table->string('title')->nullable();
                $table->string('description')->nullable();
                $table->string('link')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mediafile_translations');
    }
}
