<?php

use AvengersMG\MGCms2019\Database\Seeds\PermissionTableSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;

class InsertPermissionsFromSeederToPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Llamar al semillero */
        Artisan::call('db:seed', [
            '--class' => PermissionTableSeeder::class,
            '--force' => true,
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /* Eliminar los permisos que están en el semillero */
        Permission::whereIn('name', PermissionTableSeeder::getPermissions())->delete();
    }
}
