<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;

class RemoveOriginalPermissionsFromTablePermissions extends Migration
{
    private $permissions = [
        'administrador',
        'editor',
    ];

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Eliminar permisos */
        Permission::whereIn('name', $this->permissions)->delete();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Permission::insert(
            /* Crear arreglo con timestamps y nombre de guardia */
            collect($this->permissions)->map(function($item){
                return [
                    'name' => $item,
                    'guard_name' => 'web',
                    'created_at' => Carbon::now()->toDateTimeString()
                ];
            })->all()
        );
    }
}
