<?php

use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Restaurant;
use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeysToRestaurantServicePivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('restaurant_service')) {
            /* Eliminar todos los valores que no existan en las tablas */
            DB::table('restaurant_service')->whereNotIn('service_id', Service::pluck('id'))->orWhereNotIn('restaurant_id', Restaurant::pluck('id'))->delete();

            Schema::table('restaurant_service', function (Blueprint $table) {
                /* Cambiar a enteros sin signos */
                $table->unsignedInteger('restaurant_id')->change();
                $table->unsignedInteger('service_id')->change();

                /* Añadir llaves foráneas y cascadeo */
                $table->foreign('restaurant_id')->references('id')->on('restaurants')->onDelete('cascade')->onUpdate('cascade');
                $table->foreign('service_id')->references('id')->on('services')->onDelete('cascade')->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('restaurant_service', function (Blueprint $table) {
            /* Remover llaves foráneas y cascadeo */
            $table->dropForeign('restaurant_service_restaurant_id_foreign');
            $table->dropForeign('restaurant_service_service_id_foreign');
        });

        /* Necesario en una segunda función para que primer aplique la remoción de llaves y luego cambie el tipo */
        Schema::table('restaurant_service', function (Blueprint $table) {
            /* Cambiar a enteros regulares */
            $table->integer('restaurant_id')->change();
            $table->integer('service_id')->change();
        });
    }
}
