<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContactRequestTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('contact_request')) {
            Schema::create('contact_request', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('form_id')->unsigned()->index()->nullable();
                $table->foreign('form_id')->references('id')->on('forms')->onDelete('cascade');
                $table->string('status', 15);
                $table->json('assigned');
                $table->string('locale', 15);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_request');
    }
}
