<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveConstraintUniquePermalinksToPageTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Revisar si la columna existe antes de modificarla */
        if (Schema::hasColumn('page_translations', 'perman_link')) {
            Schema::table('page_translations', function (Blueprint $table) {
                $table->dropUnique('page_translations_perman_link_unique');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /* Revisar si la columna existe antes de modificarla */
        if (Schema::hasColumn('page_translations', 'perman_link')) {
            Schema::table('page_translations', function (Blueprint $table) {
                $table->unique('perman_link');
            });
        }
    }
}
