<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNullableConstrainsToColumnTheme extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /* Revisar si la columna existe antes de modificarla */
        if (Schema::hasColumn('sites', 'theme')) {
            Schema::table('sites', function (Blueprint $table) {
                $table->string('theme')->nullable()->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /* Revisar si la columna existe antes de modificarla */
        if (Schema::hasColumn('sites', 'theme')) {
            Schema::table('sites', function (Blueprint $table) {
                $table->string('theme')->nullable(false)->change();
            });
        }
    }
}
