<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBannersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('banners')) {
            Schema::create('banners', function (Blueprint $table) {
                $table->increments('id');
                $table->enum('position', ['top', 'left', 'bottom', 'right']);
                $table->enum('type', ['img', 'text']);
                $table->integer('priority');
                $table->boolean('countdown')->nullable();
                $table->boolean('duration')->nullable();
                $table->date('start_date');
                $table->date('end_date');
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('banner_translations')) {
            Schema::create('banner_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('banner_id')->unsigned();
                $table->integer('page_id')->unsigned()->nullable();
                $table->string('url_custom')->nullable();
                $table->string('name');
                $table->string('caption')->nullable();
                $table->longText('body')->nullable();
                $table->string('img')->nullable();
                $table->boolean('active');
                $table->string('category')->nullable();
                $table->string('action')->nullable();
                $table->string('locale');
                $table->unique(['banner_id','locale']);
                $table->timestamps();
            });
        }

        Schema::table('banner_translations', function($table) {
            $table->foreign('banner_id')->references('id')->on('banners')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banner_translations');
        Schema::dropIfExists('banners');
    }
}
