<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRestaurantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('restaurants')) {
            Schema::create('restaurants', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('page_id');

                $table->foreign('page_id')
                    ->references('id')->on('pages')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('restaurant_translations')) {
            Schema::create('restaurant_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('restaurant_id');

                $table->foreign('restaurant_id')
                    ->references('id')->on('restaurants')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');

                $table->string('locale')->nullable();
                $table->string('name')->nullable();
                $table->json('menus')->nullable();
                $table->string('title')->nullable();
                $table->string('subtitle')->nullable();
                $table->longText('body')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('restaurant_translations');
        Schema::dropIfExists('restaurants');
    }
}
