<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateToursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('tours')) {
            Schema::create('tours', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('page_id');
                $table->timestamps();

                $table->foreign('page_id')->references('id')->on('pages')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }

        if (!Schema::hasTable('tour_translations')) {
            Schema::create('tour_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('tour_id');
                $table->string('locale')->nullable();
                $table->string('name')->nullable();
                $table->string('activity')->nullable();
                $table->string('recommendations')->nullable();
                $table->string('restriction')->nullable();
                $table->string('duration')->nullable();
                $table->longText('short_description')->nullable();
                $table->timestamps();

                $table->foreign('tour_id')->references('id')->on('tours')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tour_translations');
        Schema::dropIfExists('tours');
    }
}
