<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMaxPaxTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('max_paxs')) {
            Schema::create('max_paxs', function (Blueprint $table) {
                $table->increments('id');
                $table->smallInteger('adults');
                $table->smallInteger('childrens');
                $table->smallInteger('max_pax');
                $table->unsignedInteger('room_id');
                $table->timestamps();

                $table->foreign('room_id')->references('id')->on('rooms')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('max_paxs');
    }
}
