<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSpecialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('specials')) {
            Schema::create('specials', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('page_id');
                $table->date('start_date')->nullable();
                $table->date('end_date')->nullable();
                $table->date('start_travel')->nullable();
                $table->date('end_travel')->nullable();
                $table->boolean('countdown')->nullable();
                $table->boolean('active')->nullable();
                $table->boolean('undefined')->nullable();
                $table->timestamps();

                $table->foreign('page_id')->references('id')->on('pages')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }

        if (!Schema::hasTable('special_translations')) {
            Schema::create('special_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('special_id');
                $table->string('locale');
                $table->string('name');
                $table->longText('short_description')->nullable();
                $table->longText('terms')->nullable();
                $table->timestamps();

                $table->foreign('special_id')->references('id')->on('specials')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('special_translations');
        Schema::dropIfExists('specials');
    }
}
