<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRoomsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('rooms')) {
            Schema::create('rooms', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('category_id')->nullable();
                $table->unsignedInteger('page_id');
                $table->string('api_id');
                $table->string('floor_plan')->nullable();
                $table->json('gallery')->nullable();
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('categories')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');

                $table->foreign('page_id')->references('id')->on('pages')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }

        if (!Schema::hasTable('room_translations')) {
            Schema::create('room_translations', function (Blueprint $table) {
                $table->increments('id');
                $table->string('locale');
                $table->unsignedInteger('room_id');
                $table->string('name');
                $table->longText('description')->nullable();
                $table->string('beds');
                $table->string('bathrooms');
                //$table->json('capacity')->nullable();
                $table->string('capacity');
                $table->string('adults');
                $table->string('childrens');
                $table->string('floor_area');
                $table->timestamps();

                $table->foreign('room_id')->references('id')->on('rooms')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('room_translations');
        Schema::dropIfExists('rooms');
    }
}
