<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCardTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cards')) {
            Schema::create('cards', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('page_id');
                $table->integer('priority');
                $table->timestamps();

                $table->foreign('page_id')->references('id')->on('pages')->onDelete('cascade');
            });
        }

        if (!Schema::hasTable('card_traslations')) {
            Schema::create('card_traslations', function (Blueprint $table) {
                $table->increments('id');
                $table->string('title');
                $table->string('title_two')->nullable();
                $table->longText('body');
                $table->string('image')->nullable();
                $table->string('link')->nullable();
                $table->string('slug')->nullable();
                $table->string('locale');
                $table->integer('card_id')->unsigned()->index();
                $table->foreign('card_id')->references('id')->on('cards')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('card_traslations');
        Schema::dropIfExists('cards');
    }
}
