<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('pages')) {
            Schema::create('pages', function (Blueprint $table) {
                $table->increments('id');
                $table->string('layout');
                $table->string('template')->nullable();
                $table->nestedSet();
                $table->unsignedInteger('site_id');
                $table->boolean('index')->default(true)->nullable();
                $table->foreign('site_id')->references('id')->on('sites');
                $table->softDeletes();
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('page_translations')) {
            Schema::create('page_translations', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('page_id')->unsigned();
                $table->string('name')->nullable();
                $table->string('title')->nullable();
                $table->string('sub_title')->nullable();
                $table->longText('description')->nullable();
                $table->longText('excerpt')->nullable();
                $table->enum('status', ['hidden', 'review' ,'published']);
                $table->boolean('navigation')->default(true)->nullable();
                $table->string('slug')->nullable();
                $table->string('perman_link')->unique();
                $table->string('meta_title')->nullable();
                $table->string('meta_description')->nullable();
                $table->boolean('seo')->nullable();
                $table->string('locale')->index();
                $table->unique(['page_id','locale']);
                $table->softDeletes();
                $table->foreign('page_id')->references('id')->on('pages')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_translations');
        Schema::dropIfExists('pages');
    }
}
