<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSitesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('sites')) {
            Schema::create('sites', function (Blueprint $table) {
                $table->increments('id');
                $table->string('name');
                $table->string('domain');
                $table->json('sociales')->nullable();
                $table->string('logo')->nullable();
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('site_translations')) {
            Schema::create('site_translations', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('site_id')->unsigned();
                $table->string('meta_title')->nullable();
                $table->string('meta_description')->nullable();
                $table->text('phone')->nullable();
                $table->json('schema')->nullable();
                $table->string('locale')->index();

                $table->unique(['site_id','locale']);
                $table->foreign('site_id')->references('id')->on('sites')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_translations');
        Schema::dropIfExists('sites');
    }
}
