<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediafilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mediafiles')) {
            Schema::create('mediafiles', function (Blueprint $table) {
                $table->increments('id');
                $table->morphs('mediafilable');
                $table->string('name')->nullable();
                $table->string('path');
                $table->integer('priority')->default(0);
                $table->string('alt')->nullable();
                $table->string('title')->nullable();
                $table->string('description')->nullable();
                $table->boolean('status')->default(1);
                $table->unsignedInteger('type_id')->nullable();
                $table->foreign('type_id')
                    ->references('id')->on('file_types')
                    ->onDelete('cascade');
                $table->string('locale');
                $table->string('link')->nullable();
                $table->string('file_size')->nullable();
                $table->string('content_type')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mediafiles');
    }
}
