<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use Illuminate\Database\Seeder;
use AvengersMG\MGCms2019\App\Cms\Components\Wysiwygs\Wysiwyg;
use Faker\Factory;

class WysiwygTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \App::setLocale('es');
        foreach ([1,2,3,4] as $numberpage) {
            $content = new Wysiwyg();
            $faker = Factory::create();
            $content->name=$faker->name;
            // $page->name="content ".$numberpage;
            foreach (app()->make('translatable.locales')->all() as $locale) {
                $content->translateOrNew($locale)->wysiwyg = $faker->randomHtml(2, 3);
                $content->translateOrNew($locale)->description = $faker->text." en ".$locale;
            }
            $content->save();
        }
    }
}
