<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class SocialmediasTableSeeder extends Seeder
{
    private static $socialnetworks = [
        "FaceBook",
        "Instagram",
        "YouTube",
        "TripAdvisor",
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /** @var Collection|string[] Buscar las que ya estén insertados y dejarlos ahí */
        $already_in = Socialmedia::whereIn('description', static::$socialnetworks)->pluck('description');

        /** @var Collection|string[] Redes sociales faltantes */
        $to_write = collect(static::$socialnetworks)->diff($already_in);

        Socialmedia::insert(
            /* Crear arreglo con timestamps y nombre de guardia */
            $to_write->map(function($item){
                return [
                    'description' => $item,
                    'created_at' => Carbon::now()->toDateTimeString()
                ];
            })->all()
        );
    }

    /**
     * Método público para recuperar los permisos de este semillero
     *
     * @return string[] Identificadores de permisos
     */
    public static function getSocialNetworks()
    {
        return static::$socialnetworks;
    }
}
