<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Config;

class SitesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $site = new Site();
        $site->name = "Primer sitio";
        $site->domain = 'mgcms.test';/* Cambiar el sitio en el CMS */
        foreach (app()->make('translatable.locales')->all() as $locale) {
            $site->translateOrNew($locale)->meta_title = "Description in {$locale}";
            $site->translateOrNew($locale)->meta_description = "Description in {$locale}";
            $site->translateOrNew($locale)->phone = "3221008052";
            $site->translateOrNew($locale)->schema = json_encode(""); /* Vacío para HTML válido desde el principio */
        }

        $site->save();
    }
}
