<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use Illuminate\Database\Seeder;
use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service;

class ServicesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $arr_services = [
            [
                'name' => 'Breakfast',
                'name_es' => 'Desayuno',
                'icon' => 'fas fa-bacon'
            ],
            [
                'name' => 'MENU FOR KIDS',
                'name_es' => 'MENU PARA NIÑOS',
                'icon' => 'class="fas fa-cookie-bite'
            ],
            [
                'name' => 'LUNCH',
                'name_es' => 'ALMUERZO',
                'icon' => 'fas fa-apple-alt'
            ],
            [
                'name' => 'DINNER',
                'name_es' => 'CENA',
                'icon' => 'fas a-phone'
            ],
            [
                'name' => 'BISTRO MENU',
                'name_es' => 'MENU BISTRO',
                'image' => 'mediafiles/amenities/icons/iron.png'
            ],
            [
                'name' => 'MEXICAN MENU',
                'name_es' => 'MENU NACIONAL',
                'icon' => 'fas fa-pepper-hot'
            ],
            [
                'name' => 'ITALIAN MENU',
                'name_es' => 'MENU ITALIANO',
                'icon' => 'fas fa-pizza'
            ],
            [
                'name' => 'ASIAN MENU',
                'name_es' => 'MENU ASIATICO',
                'icon' => 'fas fa-user-ninja'
            ],
            [
                'name' => 'WINE',
                'name_es' => 'VINO',
                'icon' => 'fas fa-wine-glass-alt'
            ],
            [
                'name' => 'CREATIVE MENU',
                'name_es' => 'MENU CREATIVO',
                'image' => 'mediafiles/amenities/icons/mirror.png'
            ],
            [
                'name' => 'DRINKS & SNACKS',
                'name_es' => 'BEBIDAS & SNACKS',
                'icon' => 'fas fa-french-fries'
            ],
            [
                'name' => 'GOURMET BITES',
                'name_es' => 'GOURMET BITES',
                'image' => 'mediafiles/amenities/icons/french-perfume.png'
            ],
            [
                'name' => 'CASUAL CUISINE',
                'name_es' => 'COCINA CASUAL',
                'image' => 'mediafiles/amenities/icons/washing-machine.png'
            ],
            [
                'name' => 'BEACH LUNCH',
                'name_es' => 'DESAYUNO EN LA PLAYA',
                'icon' => 'fas fa-umbrella-beach'
            ],
            [
                'name' => 'BEER',
                'name_es' => 'CERVEZA',
                'icon' => 'fas fa-beer'
            ],
            [
                'name' => 'COCKTAILS',
                'name_es' => 'CÓCTELES',
                'icon' => 'fas fa-cocktail'
            ],

        ];

        foreach ($arr_services as $services) {
            Service::create($services);
        }
    }
}
