<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleTableSeeder extends Seeder
{
    private static $roles = [
        'super_admin' => [],
        'admin' => [
            "listar_usuarios",
            "ver_usuarios",
            "ver_usuario_propio",
            "editar_usuarios",
            "editar_usuario_propio",
            "editar_rol_propio",
            "editar_sitios_de_usuario_propio",
            "listar_roles",
            "ver_roles",
            "editar_roles",
            "listar_permisos",
            "ver_permisos",
            "editar_permisos",
            "listar_sitios",
            "ver_sitios_asignados",
            "editar_sitios_asignados",
            "listar_paginas_de_sitios_asignados",
            "crear_paginas_para_sitios_asignados",
            "ver_paginas_de_sitios_asignados",
            "editar_paginas_de_sitios_asignados",
            "listar_amenidades",
            "ver_amenidades",
            "crear_amenidades",
            "editar_amenidades",
            "listar_categorias",
            "ver_categorias",
            "crear_categorias",
            "editar_categorias",
            "listar_servicios",
            "ver_servicios",
            "crear_servicios",
            "editar_servicios",
            "listar_mediafiles_de_sitios_asignados",
            "ver_mediafiles_de_sitios_asignados",
            "crear_mediafiles_para_sitios_asignados",
            "crear_directorios",
            "editar_mediafiles_de_sitios_asignados",
            "listar_tipos",
            "ver_tipos",
            "listar_formas",
            "ver_formas",
            "editar_formas",
            "listar_banners",
            "ver_banners",
            "crear_banners",
            "editar_banners",
            "listar_resenas",
            "ver_resenas",
            "crear_resenas",
            "editar_resenas",
            "listar_servicios_de_viaggio",
            "ver_servicios_de_viaggio",
            "editar_servicios_de_viaggio",
        ],
        'editor' => [
            'ver_usuario_propio',
            'editar_usuario_propio',
            'listar_paginas_de_sitios_asignados',
            'crear_paginas_para_sitios_asignados',
            'ver_paginas_de_sitios_asignados',
            'editar_paginas_de_sitios_asignados',
            'listar_amenidades',
            'ver_amenidades',
            'crear_amenidades',
            'editar_amenidades',
            'listar_categorias',
            'ver_categorias',
            'crear_categorias',
            'editar_categorias',
            'listar_servicios',
            'ver_servicios',
            'crear_servicios',
            'editar_servicios',
            'crear_directorios',
            'listar_resenas',
            'ver_resenas',
            'crear_resenas',
            'editar_resenas',
            'listar_mediafiles_de_sitios_asignados',
            'crear_mediafiles_para_sitios_asignados',
            'ver_mediafiles_de_sitios_asignados',
            'editar_mediafiles_de_sitios_asignados',
            "listar_servicios_de_viaggio",
            "ver_servicios_de_viaggio",
            "editar_servicios_de_viaggio",
        ],
        'user' => [
            'ver_usuario_propio',
            'editar_usuario_propio',
            'listar_paginas_de_sitios_asignados',
            'listar_mediafiles_de_sitios_asignados',
            'ver_mediafiles_de_sitios_asignados',
        ],
        'ecommerce' => [
            'ver_usuario_propio',
            'editar_usuario_propio',
            'listar_disponibilidades',
            'editar_disponibilidades',
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = collect(static::$roles);

        $role_names = $roles->keys();

        /** @var Collection|string[] Buscar los que ya estén insertados y dejarlos ahí */
        $already_in = Role::whereIn('name', $role_names)->pluck('name');

        /** @var Collection|string[] Roles faltantes */
        $to_write = collect($role_names)->diff($already_in);

        Role::insert(
            /* Crear arreglo con timestamps y nombre de guardia */
            $to_write->map(function($item){
                return [
                    'name' => $item,
                    'guard_name' => 'web',
                    'created_at' => Carbon::now()->toDateTimeString()
                ];
            })->all()
        );

        /* Asignar permisos */
        collect($role_names)->each(function($item) use ($roles){
            Role::where('name', $item)->first()->syncPermissions($roles->get($item));
        });
    }

    /**
     * Método público para recuperar los roles de este semillero
     *
     * @return array[] Listas de permisos con nombres de roles como índices
     */
    public static function getRoles()
    {
        return static::$roles;
    }
}
