<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    private static $permissions = [
        "listar_usuarios",
        "crear_usuarios",
        "ver_usuarios",
        "ver_usuario_propio",
        "editar_usuarios",
        "editar_usuario_propio",
        "editar_rol_propio",
        "editar_sitios_de_usuario_propio",
        "eliminar_usuarios",
        "listar_roles",
        "crear_roles",
        "ver_roles",
        "editar_roles",
        "eliminar_roles",
        "listar_permisos",
        "crear_permisos",
        "ver_permisos",
        "editar_permisos",
        "eliminar_permisos",
        "listar_sitios",
        "crear_sitios",
        "ver_sitios",
        "ver_sitios_asignados",
        "editar_sitios",
        "editar_sitios_asignados",
        "editar_dominio_de_sitios",
        "editar_dominio_de_sitios_asignados",
        "eliminar_sitios",
        "eliminar_sitios_asignados",
        "listar_paginas",
        "listar_paginas_de_sitios_asignados",
        "crear_paginas",
        "crear_paginas_para_sitios_asignados",
        "ver_paginas",
        "ver_paginas_de_sitios_asignados",
        "editar_paginas",
        "editar_paginas_de_sitios_asignados",
        "eliminar_paginas",
        "eliminar_paginas_de_sitios_asignados",
        "listar_wysiwygs",
        "ver_wysiwygs",
        "crear_wysiwygs",
        "editar_wysiwygs",
        "eliminar_wysiwygs",
        "listar_amenidades",
        "ver_amenidades",
        "crear_amenidades",
        "editar_amenidades",
        "eliminar_amenidades",
        "listar_categorias",
        "ver_categorias",
        "crear_categorias",
        "editar_categorias",
        "eliminar_categorias",
        "listar_servicios",
        "ver_servicios",
        "crear_servicios",
        "editar_servicios",
        "eliminar_servicios",
        "listar_mediafiles",
        "listar_mediafiles_de_sitios_asignados",
        "ver_mediafiles",
        "ver_mediafiles_de_sitios_asignados",
        "crear_mediafiles",
        "crear_mediafiles_para_sitios_asignados",
        "crear_directorios",
        "editar_mediafiles",
        "editar_mediafiles_de_sitios_asignados",
        "eliminar_mediafiles",
        "eliminar_mediafiles_de_sitios_asignados",
        "crear_tipos",
        "listar_tipos",
        "ver_tipos",
        "editar_tipos",
        "eliminar_tipos",
        "listar_formas",
        "ver_formas",
        "crear_formas",
        "editar_formas",
        "eliminar_formas",
        "listar_disponibilidades",
        "editar_disponibilidades",
        "listar_banners",
        "ver_banners",
        "crear_banners",
        "editar_banners",
        "eliminar_banners",
        "listar_resenas",
        "ver_resenas",
        "crear_resenas",
        "editar_resenas",
        "eliminar_resenas",
        "listar_servicios_de_viaggio",
        "ver_servicios_de_viaggio",
        "crear_servicios_de_viaggio",
        "editar_servicios_de_viaggio",
        "eliminar_servicios_de_viaggio",
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /** @var Collection|string[] Buscar los que ya estén insertados y dejarlos ahí */
        $already_in = Permission::whereIn('name', static::$permissions)->pluck('name');

        /** @var Collection|string[] Permisos faltantes */
        $to_write = collect(static::$permissions)->diff($already_in);

        Permission::insert(
            /* Crear arreglo con timestamps y nombre de guardia */
            $to_write->map(function($item){
                return [
                    'name' => $item,
                    'guard_name' => 'web',
                    'created_at' => Carbon::now()->toDateTimeString()
                ];
            })->all()
        );
    }

    /**
     * Método público para recuperar los permisos de este semillero
     *
     * @return string[] Identificadores de permisos
     */
    public static function getPermissions()
    {
        return static::$permissions;
    }
}
