<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Database\Seeder;

class PagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $langs = [
            'en' => [
                'home' => [
                    'name' => 'Home',
                    'title' => 'Home',
                    'slug' => '/',
                    'perman_link' => '/',
                    'template' => 'home',
                ],
                'accomodations' => [
                    'name' => 'accomodations',
                    'title' => 'accomodations',
                    'slug' => 'accomodations',
                    'perman_link' => '/accomodations',
                    'template' => 'accomodations',
                    'array' => array(
                        'allure' => [
                            'name' => 'allure',
                            'title' => 'allure',
                            'slug' => 'allure',
                            'perman_link' => '/accomodations/allure',
                            'template' => 'list-rooms',
                            'parent' => '/accomodations',
                            'array' =>[
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/accomodations/allure/room',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/allure',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/accomodations/allure/suite-1',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/allure',
                                ]]

                        ],
                        'Sierra' => [
                            'name' => 'Sierra',
                            'title' => 'Sierra',
                            'slug' => 'Sierra',
                            'perman_link' => '/accomodations/sierra',
                            'template' => 'list-rooms',
                            'parent' => '/accomodations',
                            'array' => [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/accomodations/sierra/room',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/sierra',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/accomodations/sierra/suite-1',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/sierra',
                                ]
                            ]

                        ],
                        'Lush' => [
                            'name' => 'Lush',
                            'title' => 'Lush',
                            'slug' => 'Lush',
                            'perman_link' => '/accomodations/lush',
                            'template' => 'list-rooms',
                            'parent' => '/accomodations',
                            'array' => [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/accomodations/lush/room',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/lush',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/accomodations/lush/suite-1',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/lush',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/accomodations/lush/suite-2',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/lush',
                                ]
                            ]
                        ],
                        'Bahia' => [
                            'name' => 'Bahía',
                            'title' => 'Bahía',
                            'slug' => 'Bahia',
                            'perman_link' => '/accomodations/bahia',
                            'template' => 'list-rooms',
                            'parent' => '/accomodations',
                            'array' => [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/accomodations/bahia/room',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/bahia',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/accomodations/bahia/suite-1',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/bahia',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/accomodations/bahia/suite-2',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/bahia',
                                ]
                            ]
                        ],
                        'Armony' => [
                            'name' => 'Armony',
                            'title' => 'Armony',
                            'slug' => 'Armony',
                            'perman_link' => '/accomodations/armony',
                            'template' => 'list-rooms',
                            'parent' => '/accomodations',
                            'array' =>  [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/accomodations/armony/room',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/armony',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/accomodations/armony/suite-1',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/armony',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/accomodations/armony/suite-2',
                                    'template' => 'single-room',
                                    'parent' => '/accomodations/armony',
                                ]
                            ]
                        ],
                    )
                ],
                'restaurants' => [
                    'name' => 'restaurants',
                    'title' => 'restaurants',
                    'slug' => 'restaurants',
                    'template' => 'restaurants',
                    'perman_link' => '/restaurants',
                    'array' => [
                        [
                            'name' => 'Esscence',
                            'title' => 'Esscence',
                            'slug' => 'esscence',
                            'perman_link' => '/restaurants/esscence',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'la brise',
                            'title' => 'la brise',
                            'slug' => 'la-brise',
                            'perman_link' => '/restaurants/la-brise',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'finestra',
                            'title' => 'finestra',
                            'slug' => 'finestra',
                            'perman_link' => '/restaurants/finestra',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'blend',
                            'title' => 'blend',
                            'slug' => 'blend',
                            'perman_link' => '/restaurants/blend',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'insu',
                            'title' => 'insu',
                            'slug' => 'insu',
                            'perman_link' => '/restaurants/insu',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'drops',
                            'title' => 'drops',
                            'slug' => 'drops',
                            'perman_link' => '/restaurants/drops',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'parota',
                            'title' => 'parota',
                            'slug' => 'parota',
                            'perman_link' => '/restaurants/parota',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'the vent',
                            'title' => 'the vent',
                            'slug' => 'the-vent',
                            'perman_link' => '/restaurants/the-vent',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ],
                        [
                            'name' => 'kite',
                            'title' => 'kite',
                            'slug' => 'kite',
                            'perman_link' => '/restaurants/kite',
                            'template' => 'singe-restaurant',
                            'parent' => '/restaurants'
                        ]
                    ]
                ],
                'weddings' => [
                    'name' => 'weddings',
                    'title' => 'weddings',
                    'slug' => 'weddings',
                    'template' => 'default',
                    'perman_link' => '/weddings',
                    'array' => [
                        [
                            'name' => 'packages',
                            'title' => 'packages',
                            'slug' => 'packages',
                            'template' => 'default',
                            'perman_link' => '/weddings/packages',
                            'parent' => '/weddings'
                        ],
                        [
                            'name' => 'honeymoon',
                            'title' => 'honeymoon',
                            'slug' => 'honeymoon',
                            'perman_link' => '/weddings/honeymoon',
                            'template' => 'default',
                            'parent' => '/weddings'
                        ],
                        [
                            'name' => 'vow renewal',
                            'title' => 'vow renewal',
                            'slug' => 'vow-renewal',
                            'perman_link' => '/weddings/vow-renewal',
                            'template' => 'default',
                            'parent' => '/weddings'
                        ],
                    ]
                ],
                'groups' => [
                    'name' => 'groups',
                    'title' => 'groups',
                    'slug' => 'groups',
                    'template' => 'default',
                    'perman_link' => '/groups',
                ],
                'services' => [
                    'name' => 'services',
                    'title' => 'services',
                    'slug' => 'services',
                    'perman_link' => '/services',
                    'template' => 'list-services',
                    'array' => [
                        [
                            'name' => 'vacation club',
                            'title' => 'vacation club',
                            'slug' => 'vacation-club',
                            'perman_link' => '/services/vacation-club',
                            'template' => 'default',
                            'parent' => '/services'
                        ],
                        [
                            'name' => 'tours',
                            'title' => 'tours',
                            'slug' => 'tours',
                            'perman_link' => '/services/tours',
                            'parent' => '/services',
                            'template' => 'list-tour',
                            'array' => [
                                [
                                    'name' => 'Whale Photo Safari',
                                    'title' => 'Whale Photo Safari',
                                    'slug' => 'whale-photo-safari',
                                    'perman_link' => '/services/tours/Whale Photo Safari',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'Mountain Adventure',
                                    'title' => 'Mountain Adventure',
                                    'slug' => 'mountain-adventure',
                                    'perman_link' => '/services/tours/mountain-adventure',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'sierra madre expedition',
                                    'title' => 'sierra madre expedition',
                                    'slug' => 'sierra-madre-expedition',
                                    'perman_link' => '/services/tours/sierra-madre-xpedition',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'outdoor adventure',
                                    'title' => 'outdoor adventure',
                                    'slug' => 'outdoor-adventure',
                                    'perman_link' => '/services/tours/outdoor-adventure',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'dolphin signature swim',
                                    'title' => 'dolphin signature swim',
                                    'slug' => 'dolphin-signature-swim',
                                    'perman_link' => '/services/tours/dolphin-signature-swim',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'las caletas',
                                    'title' => 'las caletas',
                                    'slug' => 'las-caletas',
                                    'perman_link' => '/services/tours/las-caletas',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'snorkel with sea lions',
                                    'title' => 'snorkel with sea lions',
                                    'slug' => 'snorkel-with-sea-lions',
                                    'perman_link' => '/services/tours/snorkel-with-sea-lions',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'rhythms of the night',
                                    'title' => 'rhythms of the night',
                                    'slug' => 'rhythms-of-the-night',
                                    'perman_link' => '/services/tours/rhythms-of-the-night',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'Canopy Tour VAD',
                                    'title' => 'Canopy Tour VAD',
                                    'slug' => 'canopy-tourvad',
                                    'perman_link' => '/services/tours/canopy-tourvad',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => "wild atv's",
                                    'title' => "wild atv's",
                                    'slug' => 'wild-atvs',
                                    'perman_link' => '/services/tours/wild-atvs',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'las caletas 1-tank dive',
                                    'title' => 'las caletas 1-tank dive',
                                    'slug' => 'las-caletas-1-tankdive',
                                    'perman_link' => '/services/tours/las-caletas-1-tankdive',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'las caletas 2-tank dive',
                                    'title' => 'las caletas 2-tank dive',
                                    'slug' => 'las-caletas-2-tank-dive',
                                    'perman_link' => '/services/tours/las-caletas-2-tank-dive',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'sea lion encounter',
                                    'title' => 'sea lion encounter',
                                    'slug' => 'sea-lion-encounter',
                                    'perman_link' => '/services/tours/sea-lion-encounter',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'catamaran',
                                    'title' => 'catamaran',
                                    'slug' => 'catamaran',
                                    'perman_link' => '/services/tours/catamaran',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'canopy river',
                                    'title' => 'canopy river',
                                    'slug' => 'canopy-river',
                                    'perman_link' => '/services/tours/canopy-river',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'pueblos',
                                    'title' => 'pueblos',
                                    'slug' => 'pueblos',
                                    'perman_link' => '/services/tours/pueblos',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'city tour',
                                    'title' => 'city tour',
                                    'slug' => 'city-tour',
                                    'perman_link' => '/services/tours/city-tour',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'walking downtown',
                                    'title' => 'walking downtown',
                                    'slug' => 'walking-downtown',
                                    'perman_link' => '/services/tours/walking-downtown',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'marigalante',
                                    'title' => 'marigalante',
                                    'slug' => 'marigalante',
                                    'perman_link' => '/services/tours/marigalante',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'san sebastian',
                                    'title' => 'san sebastian',
                                    'slug' => 'san-sebastian',
                                    'perman_link' => '/services/tours/san-sebastian',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'puerto vallarta city tour',
                                    'title' => 'puerto vallarta city tour',
                                    'slug' => 'puerto-vallarta-city-tour',
                                    'perman_link' => '/services/tours/puerto-vallarta-city-tour',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'horseback riding',
                                    'title' => 'horseback riding',
                                    'slug' => 'horseback-riding',
                                    'perman_link' => '/services/tours/horseback-riding',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'Fishing Parties and Charters',
                                    'title' => 'Fishing Parties and Charters',
                                    'slug' => 'fishing-parties-and-charters',
                                    'perman_link' => '/services/tours/fishing-parties-and-charters',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ],
                                [
                                    'name' => 'thriller!!',
                                    'title' => 'thriller!!',
                                    'slug' => 'thriller',
                                    'perman_link' => '/services/tours/thriller',
                                    'parent' => '/services/tours',
                                    'template' => 'singe-tour',

                                ]

                            ]
                        ],
                        [
                            'name' => 'marival kids',
                            'title' => 'marival kids',
                            'slug' => 'marival-kids',
                            'perman_link' => '/services/marival-kids',
                            'template' => 'default',
                            'parent' => '/services'
                        ],
                        [
                            'name' => 'marival teens',
                            'title' => 'marival teens',
                            'slug' => 'marival-teens',
                            'perman_link' => '/services/marival-teens',
                            'template' => 'default',
                            'parent' => '/services'
                        ]
                    ]
                ],
                'resort' => [
                    'name' => 'resort',
                    'title' => 'resort',
                    'slug' => 'resort',
                    'template' => 'default',
                    'perman_link' => '/resort',
                    'array' => [
                        [
                            'name' => 'facilities',
                            'title' => 'facilities',
                            'slug' => 'facilities',
                            'perman_link' => '/services/facilities',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'eco marival',
                            'title' => 'eco marival',
                            'slug' => 'eco-marival',
                            'perman_link' => '/services/eco-marival',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'information',
                            'title' => 'information',
                            'slug' => 'information',
                            'perman_link' => '/services/information',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'location',
                            'title' => 'location',
                            'slug' => 'location',
                            'perman_link' => '/services/location',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'permissions',
                            'title' => 'permissions',
                            'slug' => 'permissions',
                            'perman_link' => '/services/permissions',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'contact',
                            'title' => 'contact',
                            'slug' => 'contact',
                            'perman_link' => '/services/contact',
                            'template' => 'default',
                            'parent' => '/resort'
                        ],
                        [
                            'name' => 'faq',
                            'title' => 'faq',
                            'slug' => 'faq',
                            'perman_link' => '/services/faq',
                            'template' => 'default',
                            'parent' => '/resort'
                        ]
                    ]
                ],
                'specials' => [
                    'name' => 'specials',
                    'title' => 'specials',
                    'slug' => 'specials',
                    'template' => 'list-specials',
                    'perman_link' => '/specials',
                ],
            ],
            /*'es' => [
                'Inicio' => [
                    'name' => 'inicio',
                    'title' => 'inicio',
                    'slug' => '/es',
                    'perman_link' => '/es'
                ],
                'habitaciones' => [
                    'name' => 'habitaciones',
                    'title' => 'habitaciones',
                    'slug' => 'habitaciones',
                    'perman_link' => '/es/habitaciones',
                    'array' => array(
                        'allure' => [
                            'name' => 'allure',
                            'title' => 'allure',
                            'slug' => 'allure',
                            'perman_link' => '/es/habitaciones/allure',
                            'parent' => '/es/habitaciones',
                            'array' =>
                                [
                                    [
                                        'name' => 'Room',
                                        'title' => 'Room',
                                        'slug' => 'Room',
                                        'perman_link' => '/es/habitaciones/allure/room',
                                        'parent' => '/es/habitaciones/allure',
                                    ],
                                    [
                                        'name' => 'suite-1',
                                        'title' => 'suite-1',
                                        'slug' => 'suite-1',
                                        'perman_link' => '/es/habitaciones/allure/suite-1',
                                        'parent' => '/es/habitaciones/allure',
                                    ]
                            ]
                        ],
                        'Sierra' => [
                            'name' => 'Sierra',
                            'title' => 'Sierra',
                            'slug' => 'Sierra',
                            'perman_link' => '/es/habitaciones/sierra',
                            'parent' => '/es/habitaciones',
                            'array' =>
                                [
                                    [
                                        'name' => 'Room',
                                        'title' => 'Room',
                                        'slug' => 'Room',
                                        'perman_link' => '/es/habitaciones/sierra/room',
                                        'parent' => '/es/habitaciones/sierra',
                                    ],
                                    [
                                        'name' => 'suite-1',
                                        'title' => 'suite-1',
                                        'slug' => 'suite-1',
                                        'perman_link' => '/es/habitaciones/sierra/suite-1',
                                        'parent' => '/es/habitaciones/sierra',
                                    ]
                                ]
                        ],
                        'Lush' => [
                            'name' => 'Lush',
                            'title' => 'Lush',
                            'slug' => 'Lush',
                            'perman_link' => '/es/habitaciones/lush',
                            'parent' => '/es/habitaciones',
                            'array' => [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/es/habitaciones/lush/room',
                                    'parent' => '/es/habitaciones/lush',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/es/habitaciones/lush/suite-1',
                                    'parent' => '/es/habitaciones/lush',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/es/habitaciones/lush/suite-2',
                                    'parent' => '/es/habitaciones/lush',
                                ]
                            ]
                        ],
                        'Bahia' => [
                            'name' => 'Bahía',
                            'title' => 'Bahía',
                            'slug' => 'Bahia',
                            'perman_link' => '/es/habitaciones/bahia',
                            'parent' => '/es/habitaciones',
                            'array' => [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/es/habitaciones/bahia/room',
                                    'parent' => '/es/habitaciones/bahia',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/es/habitaciones/bahia/suite-1',
                                    'parent' => '/es/habitaciones/bahia',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/es/habitaciones/bahia/suite-2',
                                    'parent' => '/es/habitaciones/bahia',
                                ]
                            ]
                        ],
                        'Armony' => [
                            'name' => 'Armony',
                            'title' => 'Armony',
                            'slug' => 'Armony',
                            'perman_link' => '/es/habitaciones/armony',
                            'parent' => '/es/habitaciones',
                            'array' =>  [
                                [
                                    'name' => 'Room',
                                    'title' => 'Room',
                                    'slug' => 'Room',
                                    'perman_link' => '/es/habitaciones/armony/room',
                                    'parent' => '/es/habitaciones/armony',
                                ],
                                [
                                    'name' => 'suite-1',
                                    'title' => 'suite-1',
                                    'slug' => 'suite-1',
                                    'perman_link' => '/es/habitaciones/armony/suite-1',
                                    'parent' => '/es/habitaciones/armony',
                                ],
                                [
                                    'name' => 'suite-2',
                                    'title' => 'suite-2',
                                    'slug' => 'suite-2',
                                    'perman_link' => '/es/habitaciones/armony/suite-2',
                                    'parent' => '/es/habitaciones/armony',
                                ]
                            ]
                        ],
                    )
                ],
                'restaurantes' => [
                    'name' => 'restaurants',
                    'title' => 'restaurants',
                    'slug' => 'restaurants',
                    'perman_link' => '/es/restaurantes',
                ],
                'weddings' => [
                    'name' => 'tu boda',
                    'title' => 'tu boda',
                    'slug' => 'tu boda',
                    'perman_link' => '/es/tu-boda',
                ],
                'groups' => [
                    'name' => 'grupos',
                    'title' => 'grupos',
                    'slug' => 'grupos',
                    'perman_link' => '/es/grupos',
                ],
                'services' => [
                    'name' => 'servicios',
                    'title' => 'servicios',
                    'slug' => 'servicios',
                    'perman_link' => '/es/servicios',
                ],
                'resort' => [
                    'name' => 'resort',
                    'title' => 'resort',
                    'slug' => 'resort',
                    'perman_link' => '/es/resort',
                ],
                'specials' => [
                    'name' => 'Promociones',
                    'title' => 'Promociones',
                    'slug' => 'Promociones',
                    'perman_link' => '/es/promociones',
                ],
            ]*/
        ];

        foreach ($langs as $lang => $pages) {
            $this->createPage($pages, $lang);
        }
    }

    public function createPage($pages, $lang, $parent = false)
    {
        foreach ($pages as $key => $page) {
            $model = new Page();

            $model->layout = "templates";
            $model->template = $page['template'];
            $model->site_id = 1;
            $model->translateOrNew($lang)->name = $page['name'];
            $model->translateOrNew($lang)->title = $page['title'];
            $model->translateOrNew($lang)->description = ($lang == 'en') ? 'Description' : 'Descripcion';
            $model->translateOrNew($lang)->status = 'published';
            $model->translateOrNew($lang)->navigation = true;
            $model->translateOrNew($lang)->slug = $page['slug'];
            $model->translateOrNew($lang)->perman_link = $page['perman_link'];

            if ($parent) {
                $model->parent_id = Page::whereTranslation('perman_link', $page['parent'])->first()->id;
            }

            if (!empty($page['name'])) {
                $model->save();
            }

            if (array_key_exists('array', $page)) {
                $this->createPage($page['array'], $lang, true);
            }
        }
    }
}
