<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use AvengersMG\MGCms2019\App\Cms\Mediafiles\FileType;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class ImagestypeTableSeeder extends Seeder
{
    private static $filetypes = [
        'thumbnail',
        'slider',
        'header',
        'header_mobile',
        'slider_home',
        'slider_home_mobile',
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /** @var Collection|string[] Buscar los que ya estén insertados y dejarlos ahí */
        $already_in = FileType::whereIn('type', static::$filetypes)->pluck('type');

        /** @var Collection|string[] Tipos de archivo faltantes */
        $to_write = collect(static::$filetypes)->diff($already_in);

        FileType::insert(
            /* Crear arreglo con timestamps */
            $to_write->map(function($item){
                return [
                    'type' => $item,
                    'created_at' => Carbon::now()->toDateTimeString()
                ];
            })->all()
        );
    }

    /**
     * Método público para recuperar los tipos de archivo
     * de este semillero
     *
     * @return string[] Identificadores de tipos de archivo
     */
    public static function getFiletypes()
    {
        return static::$filetypes;
    }
}
