<?php

namespace AvengersMG\MGCms2019\Database\Seeds;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity;
use Illuminate\Database\Seeder;

class AmenitiesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $arr_amenities = [
            [
                'name' => 'iPod dock',
                'name_es' => 'iPod dock',
                'icon' => 'fas fa-mobile-alt'
            ],
            [
                'name' => 'Wifi',
                'name_es' => 'Wifi',
                'icon' => 'fas fa-wifi'
            ],
            [
                'name' => 'TV',
                'name_es' => 'TV',
                'icon' => 'fas fa-tv'
            ],
            [
                'name' => 'Telephone',
                'name_es' => 'Telefono',
                'icon' => 'fas a-phone'
            ],
            [
                'name' => 'Iron and ironing board',
                'name_es' => 'Iron and ironing board',
                'image' => 'mediafiles/amenities/icons/iron.png'
            ],
            [
                'name' => 'Coffee maker',
                'name_es' => 'Coffee maker',
                'image' => 'mediafiles/amenities/icons/cofee-maker.png'
            ],
            [
                'name' => 'DVD player upon request',
                'name_es' => 'DVD player upon request',
                'image' => 'mediafiles/amenities/icons/dvd-player.png'
            ],
            [
                'name' => 'Hairdryer',
                'name_es' => 'Hairdryer',
                'image' => 'mediafiles/amenities/icons/hairdryer.png'
            ],
            [
                'name' => 'Bathrobes and slippers',
                'name_es' => 'Bathrobes and slippers',
                'image' => 'mediafiles/amenities/icons/bathrobe.png'
            ],
            [
                'name' => 'Vanity mirror',
                'name_es' => 'Vanity mirror',
                'image' => 'mediafiles/amenities/icons/mirror.png'
            ],
            [
                'name' => 'Dishwasher and other home conveniences',
                'name_es' => 'Dishwasher and other home conveniences',
                'image' => 'mediafiles/amenities/icons/dishwasher.png'
            ],
            [
                'name' => 'Luxury bath kit',
                'name_es' => 'Luxury bath kit',
                'image' => 'mediafiles/amenities/icons/french-perfume.png'
            ],
            [
                'name' => 'Laundry room (washer & dryer)',
                'name_es' => 'Laundry room (washer & dryer)',
                'image' => 'mediafiles/amenities/icons/washing-machine.png'
            ],
            [
                'name' => 'Silverware and fine glassware.',
                'name_es' => 'Laundry room (washer & dryer)',
                'image' => 'mediafiles/amenities/icons/one-spoon-and-one-fork.png'
            ],
            [
                'name' => 'Full-size refrigerator daily stocked with bottled water and soda. Beer stock upon request.',
                'name_es' => 'Full-size refrigerator daily stocked with bottled water and soda. Beer stock upon request.',
                'image' => 'mediafiles/amenities/icons/fridge.png'
            ],

        ];

        foreach ($arr_amenities as $amenity) {
            Amenity::create($amenity);
        }
    }
}
