<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;

class ScheduleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->booted(function () {
            /* Obtener creador de itinerarios */
            $schedule = $this->app->make(Schedule::class);

            /* Establecer itinerarios para actualización de especiales (ofertas) */
            $schedule->command('mgcms2019:hide-expired-specials')->daily();

            /* Establecer itinerarios para actualización de galerías */
            $schedule->command('mgcms2019:update-dynamic-gallery-priorities')->daily();

            /* Establecer itinerarios para limpieza de registro de actualización */
            $schedule->command('mgcms2019:delete-stale-availability-log-entries')->monthly();

            /** Establecer itinerarios para el envío de notificaciones push */
            $schedule->command('mgcms2019:send-specials-push-notifications')->everyThirtyMinutes();
        });
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {

    }
}
