<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Laravel\Passport\Http\Middleware\CheckClientCredentials;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        /* Registrar el middleware del flujo de revisión de credenciales */
        $this->app["router"]->aliasMiddleware('client' , CheckClientCredentials::class);
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        /* Que "lang" siempre busque dentro del lenguaje */
        Route::pattern('lang', '^('.implode('|', app()->make('translatable.locales')->all()).')');

        /* Incluir las rutas del sistema */
        Route::middleware('web', 'auth')
          ->namespace('AvengersMG\MGCms2019\App\Http\Controllers\Backend')
          ->group(__DIR__.'/../../routes/admin.php');

        /* Incluir sobrecargas o inclusiones del proyecto a las rutas del sistema */
        if (file_exists($adminRoutePath = base_path('routes/admin.php'))) {
          Route::middleware('web', 'auth')
            ->group($adminRoutePath);
        }

        Route::middleware('web')
           ->namespace('AvengersMG\MGCms2019\App\Http\Controllers')
           ->group(__DIR__.'/../../routes/web.php');

        Route::prefix('api')
           ->middleware('api')
           ->namespace('AvengersMG\MGCms2019\App\Http\Controllers')
           ->group(__DIR__.'/../../routes/api.php');
    }
}
