<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\ServiceProvider;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Repositories\Repository',
            'AvengersMG\MGCms2019\App\Repositories\RepositoryInterface'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Mediafiles\Repositories\FiletypesInterface',
            'AvengersMG\MGCms2019\App\Cms\Mediafiles\Repositories\FiletypesRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Mediafiles\Repositories\MediafilesInterface',
            'AvengersMG\MGCms2019\App\Cms\Mediafiles\Repositories\MediaRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Users\Repositories\UserInterface',
            'AvengersMG\MGCms2019\App\Cms\Users\Repositories\UserRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Roles\Repositories\RoleInterface',
            'AvengersMG\MGCms2019\App\Cms\Roles\Repositories\RoleRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Permissions\Repositories\PermissionInterface',
            'AvengersMG\MGCms2019\App\Cms\Permissions\Repositories\PermissionRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Sites\Repositories\SiteInterface',
            'AvengersMG\MGCms2019\App\Cms\Sites\Repositories\SiteRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Pages\Repositories\PageInterface',
            'AvengersMG\MGCms2019\App\Cms\Pages\Repositories\PageRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\GalleryInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\GalleryRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Cards\Repositories\CardInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Cards\Repositories\CardRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Amenities\AmenityInterface',
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Amenities\AmenityRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Categories\CategoryInterface',
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Categories\CategoryRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\RoomInterface',
            'AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\RoomRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Availabilities\Repositories\AvailabilityInterface',
            'AvengersMG\MGCms2019\App\Cms\Availabilities\Repositories\AvailabilityRepository'
        );
        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Specials\SpecialInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Specials\SpecialRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Tours\ToursInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Tours\ToursRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Restaurants\RestaurantsInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Restaurants\RestaurantsRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Services\ServiceInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Services\ServiceRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Forms\FormsInterface',
            'AvengersMG\MGCms2019\App\Cms\Forms\FormsRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Reviews\Repositories\ReviewsInterface',
            'AvengersMG\MGCms2019\App\Cms\Reviews\Repositories\ReviewsRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Banners\Repositories\BannerInterface',
            'AvengersMG\MGCms2019\App\Cms\Banners\Repositories\BannerRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\GalleryFeatureInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\GalleryFeatureRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\ItemInterface',
            'AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories\ItemRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories\SocialmediaInterface',
            'AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories\SocialmediaRepository'
        );

        $this->app->bind(
            'AvengersMG\MGCms2019\App\Cms\ApiConsumers\Repositories\ApiConsumerInterface',
            'AvengersMG\MGCms2019\App\Cms\ApiConsumers\Repositories\ApiConsumerRepository'
        );
    }
}
