<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\ServiceProvider;

class PublicServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../../public/cms/' => public_path('cms'),
        ], 'public');

        $this->publishes([
            __DIR__.'/../../resources/views/emails' => resource_path('views/emails'),
            __DIR__.'/../../resources/views/layouts' => resource_path('views/layouts'),
            __DIR__.'/../../resources/views/partials' => resource_path('views/partials'),
            __DIR__.'/../../resources/views/templates' => resource_path('views/templates'),
            __DIR__.'/../../resources/lang/en' => resource_path('lang/en'),
            __DIR__.'/../../resources/lang/es' => resource_path('lang/es'),
        ], 'frontend');
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    }
}
