<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\ServiceProvider;

class DatabaseServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        /* Permitir publicar la fábrica de modelos */
        $this->publishes([
            __DIR__.'/../../database/factories/' => database_path('/factories')
        ], 'factories');

        /* Permitir publicar las migraciones */
        $this->publishes([
            __DIR__.'/../../database/migrations/' => database_path('/migrations')
        ], 'migrations');

        /* Permitir publicar los seeders */
        $this->publishes([
            __DIR__.'/../../database/seeds/' => database_path('/seeds')
        ], 'seeds');

        /* Cargar las migraciones desde el paquete */
        $this->loadMigrationsFrom(__DIR__.'/../../database/migrations/');
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    }
}
