<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\ServiceProvider;

class ControllerServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $namespace = 'AvengersMG\MGCms2019\App\Http\Controllers';

        /* Registrar controladores */
        $this->app->make($namespace. '\Controller');
        $this->app->make($namespace. '\NavigationController');
        $this->app->make($namespace. '\Backend\AdminController');
        $this->app->make($namespace. '\Backend\Accommodations\AmenitiesController');
        $this->app->make($namespace. '\Backend\Accommodations\CategoriesController');
        $this->app->make($namespace. '\Backend\Accommodations\RoomsController');
        $this->app->make($namespace. '\Backend\Availability\AvailabilityController');
        $this->app->make($namespace. '\Backend\Banners\BannersController');
        $this->app->make($namespace. '\Backend\Components\CardController');
        $this->app->make($namespace. '\Backend\Components\GalleryController');
        $this->app->make($namespace. '\Backend\Forms\FormsController');
        $this->app->make($namespace. '\Backend\Mediafiles\FileTypesController');
        $this->app->make($namespace. '\Backend\Mediafiles\MediaFilesController');
        $this->app->make($namespace. '\Backend\Pages\PagesController');
        $this->app->make($namespace. '\Backend\Pages\RelationPagesController');
        $this->app->make($namespace. '\Backend\Permisions\PermisionsController');
        $this->app->make($namespace. '\Backend\Restaurants\RestaurantController');
        $this->app->make($namespace. '\Backend\Restaurants\ServiceController');
        $this->app->make($namespace. '\Backend\Roles\RolesController');
        $this->app->make($namespace. '\Backend\Sites\SitesController');
        $this->app->make($namespace. '\Backend\Specials\SpecialController');
        $this->app->make($namespace. '\Backend\Tours\ToursController');
        $this->app->make($namespace. '\Backend\Users\UsersController');
        $this->app->make($namespace. '\Frontend\ApiController');
        $this->app->make($namespace. '\Frontend\FormsHandlerController');
        $this->app->make($namespace. '\Frontend\AssetsController');
        $this->app->make($namespace. '\Frontend\PageController');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
