<?php

namespace AvengersMG\MGCms2019\App\Providers;

use Illuminate\Support\Arr;
use Illuminate\Support\ServiceProvider;

class ConfigServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        /* Permitir publicar las configuraciones (php artisan vendor:publish) */
        $this->publishes([
            __DIR__.'/../../config/auth.php' => config_path('auth.php'),
        ], 'auth');

        $this->publishes([
            __DIR__.'/../../config/constants.php' => config_path('constants.php'),
        ], 'constants');

        $this->publishes([
            __DIR__.'/../../config/database.php' => config_path('database.php'),
        ], 'database');

        $this->publishes([
            __DIR__.'/../../config/services.php' => config_path('services.php'),
        ], 'services');

        $this->publishes([
            __DIR__.'/../../config/translatable.php' => config_path('translatable.php'),
        ], 'translatable');

        $this->publishes([
            __DIR__.'/../../config/breadcrumbs.php' => config_path('breadcrumbs.php'),
        ], 'breadcrumbs');

        $this->publishes([
            __DIR__.'/../../config/filesystems.php' => config_path('filesystems.php'),
        ], 'filesystems');

        $this->publishes([
            __DIR__.'/../../config/websockets.php' => config_path('websockets.php'),
        ], 'websockets');
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        /* Mezclar la configuración predeterminada con la del CMS */
        $this->mergeConfigFrom(__DIR__.'/../../config/auth.php', 'auth');
        $this->mergeConfigFrom(__DIR__.'/../../config/constants.php', 'constants');
        $this->mergeConfigMultidimensionalFrom(__DIR__.'/../../config/database.php', 'database');
        $this->mergeConfigMultidimensionalFrom(__DIR__.'/../../config/services.php', 'services');
        $this->mergeConfigFrom(__DIR__.'/../../config/translatable.php', 'translatable');
        $this->mergeConfigFrom(__DIR__.'/../../config/breadcrumbs.php', 'breadcrumbs');
        $this->mergeConfigMultidimensionalFrom(__DIR__.'/../../config/filesystems.php', 'filesystems');
        $this->mergeConfigFrom(__DIR__.'/../../config/websockets.php', 'websockets');
    }

    /* Sobrescritura de métodos de mezcla (merge) para que tome en cuenta arreglos multidimensionales */

    /**
     * Merge the given configuration with the existing configuration.
     *
     * @author Koen Hoeijmakers
     * @param  string  $path
     * @param  string  $key
     * @return void
     */
    protected function mergeConfigMultidimensionalFrom($path, $key)
    {
        $config = $this->app['config']->get($key, []);
        $this->app['config']->set($key, $this->mergeConfig(require $path, $config));
    }

    /**
     * Merges the configs together and takes multi-dimensional arrays into account.
     *
     * @author Koen Hoeijmakers
     * @param  array  $original
     * @param  array  $merging
     * @return array
     */
    protected function mergeConfig(array $original, array $merging)
    {
        $array = array_merge($original, $merging);
        foreach ($original as $key => $value) {
            if (! is_array($value)) {
                continue;
            }
            if (! Arr::exists($merging, $key)) {
                continue;
            }
            if (is_numeric($key)) {
                continue;
            }
            $array[$key] = $this->mergeConfig($value, $merging[$key]);
        }
        return $array;
    }
}
