<?php

namespace AvengersMG\MGCms2019\App\Providers;

use \Exception;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Room;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\RoomInterface;
use AvengersMG\MGCms2019\App\Cms\Apis\Adapters\ApiAdapter;
use AvengersMG\MGCms2019\App\Cms\Apis\Interfaces\ApiInterface;
use AvengersMG\MGCms2019\App\Cms\Availabilities\Repositories\AvailabilityInterface;
use AvengersMG\MGCms2019\App\Cms\Components\Cards\Card;
use AvengersMG\MGCms2019\App\Cms\Components\Galleries\Gallery;
use AvengersMG\MGCms2019\App\Cms\Components\Specials\Special;
use AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Console\Commands\DeleteStaleAvailabilityLogEntries;
use AvengersMG\MGCms2019\App\Console\Commands\Flush;
use AvengersMG\MGCms2019\App\Console\Commands\HideExpiredSpecials;
use AvengersMG\MGCms2019\App\Console\Commands\MigrateDatabase;
use AvengersMG\MGCms2019\App\Console\Commands\MigrateAndSeedDatabase;
use AvengersMG\MGCms2019\App\Console\Commands\MigrateToPackage;
use AvengersMG\MGCms2019\App\Console\Commands\PublishFrontend;
use AvengersMG\MGCms2019\App\Console\Commands\RollbackFromPackage;
use AvengersMG\MGCms2019\App\Console\Commands\SeedDatabase;
use AvengersMG\MGCms2019\App\Console\Commands\UpdateDynamicGalleryPriorities;
use AvengersMG\MGCms2019\App\Console\Commands\SpecialsPushNotfication;
use AvengersMG\MGCms2019\App\Cms\Users\User;
//Observadores
use AvengersMG\MGCms2019\App\Observers\UserObserver;
use Carbon\Carbon;
use function Couchbase\defaultDecoder;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        //Column::created(function () {
        //    Cache::flush();
        //});
        //Column::deleted(function () {
        //    Cache::fSpecialsPushNotficationlush();
        //});SpecialsPushNotfication
        //Column::updaSpecialsPushNotficationted(function () {
        //    Cache::fSpecialsPushNotficationlush();
        //});
        Page::created(function () {
            Cache::flush();
        });
        Page::deleted(function () {
            Cache::flush();
        });
        Page::updated(function () {
            Cache::flush();
        });
        Mediafile::created(function () {
            Cache::flush();
        });
        Mediafile::deleted(function () {
            Cache::flush();
        });
        Mediafile::updated(function () {
            Cache::flush();
        });
        Gallery::created(function () {
            Cache::flush();
        });
        Gallery::deleted(function () {
            Cache::flush();
        });
        Gallery::updated(function () {
            Cache::flush();
        });
        Card::created(function () {
            Cache::flush();
        });
        Card::deleted(function () {
            Cache::flush();
        });
        Card::updated(function () {
            Cache::flush();
        });
        Special::updated(function () {
            Cache::flush();
        });
        Room::updated(function () {
            Cache::flush();
        });

        if ($this->app->runningInConsole()) {
            /* Registrar comandos */
            $this->commands([
                Flush::class,
                MigrateDatabase::class,
                MigrateAndSeedDatabase::class,
                MigrateToPackage::class,
                PublishFrontend::class,
                RollbackFromPackage::class,
                SeedDatabase::class,
            ]);
        }

        /* Registrar comandos que funcionan también fuera de consola */
        $this->commands([
            DeleteStaleAvailabilityLogEntries::class,
            HideExpiredSpecials::class,
            UpdateDynamicGalleryPriorities::class,
            SpecialsPushNotfication::class,
        ]);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        /* Registrar la interfaz de APIs */
        $this->app->bind(ApiInterface::class, function($app){
            /* Obtener sitio actual */
            $site = Site::current();

            /* Obtener configuraciones de sitio */
            $configs = $apiDefault = $app->make('config')->get("constants.site{$site->id}");

            /* Obtener el valor predeterminado */
            $apiDefault = $configs['api']['default'];

            /* Construir el nombre de clase de la definición */
            $classNameSpace = "AvengersMG\\MGCms2019\\App\\Cms\\Apis\\{$apiDefault}\\{$apiDefault}Api";

            /* Intentar crear nueva instancia de definición */
            $apiDefinition = new $classNameSpace;

            /* Establecer las configuraciones antes de retornar */
            $apiDefinition->setConfig(
                $configs['api']['providers'][$apiDefault]
            );

            /* Retornar la información creada */
            return $apiDefinition;
        });

        /* Registrar el manejador de APIs */
        $this->app->bind(ApiAdapter::class, function($app){
            return new ApiAdapter(
                /* Resolver la definición */
                $app->make(ApiInterface::class),
                /* Resolver los repositorios */
                $app->make(AvailabilityInterface::class),
                $app->make(RoomInterface::class)
            );
        });

    }
}
