<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers;

use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class NavigationController extends Controller
{
    public function index()
    {
        /* Obtener el sitio actual */
        $site = Site::current();

        /* Cargar las páginas */
        $site->loadMissing('pages');

        if ($site) {
            $page = $site->pages->whereIn('slug', ['/', '/es'])->first();

            if ($page) {
                return view('index', compact('site', 'page'));
            }
        }

        return Redirect::route('admin.index');
    }

    public function routing()
    {
        return view('index');
    }
}
