<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Frontend;

use \Exception;
use App;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class NewsletterController extends Controller
{
    /** alamacena nuevo suscriptores a listas de mailchimp con la API 3.0 */
    public function addUserToList(Request $request) {
        /** @var boolean Sólo saltar verificación de SSL si el ambiente es local */
        $verifySSL = !App::environment('local');

        /* Cambiar idioma de la aplicación para retornar la traducción correcta de
           de las validaciones */
        app()->setLocale($request->lang);

        /* Validación de input email */
        $request->validate([
            'FNAME' => 'required|min:2',
            'EMAIL' => 'required|email',
            'g-recaptcha-response' => 'required',
        ]);

        /* Establece el idioma de la aplicación */
        $language = $request->lang;
        
        /* Inicializa un nuevo cliente http */
        $client = new Client();

        /* Encuentra un sitio existente */
        $site = Site::current();

        /* Obtiene un arreglo de credenciales del archivo constants*/
        $credentials = config("constants.site{$site->id}.Mailchimp.credentials");

        /* Obtiene el ID de lista de MailChimp */
        $list_id = config("constants.site{$site->id}.Mailchimp.list_id.{$language}");

        try {
            /* Revisar la validez de reCaptcha */
            $res_recaptcha = $client->request('POST', "https://www.google.com/recaptcha/api/siteverify", [
                'form_params' => [
                    'secret' => config("constants.site{$site->id}.google.api_key"),
                    'response' => $request->input('g-recaptcha-response'),
                ],
                'verify' => $verifySSL,
            ]);

            /* Parsear a JSON la información recabada */
            $res_recaptcha_data = json_decode(
                $res_recaptcha->getBody()->getContents()
            );

            /* Retornar mensaje si la respuesta no es válida */
            if (!$res_recaptcha_data->success) {
                return redirect()->back()->with('alert', __('newsletter.invalid-recaptcha'));
            }

            /*
                Enviar a proveedor de newsletter

                Los datos nulos no son procesados correctamente. Hacer "casting" para convertir a cadena.

                2020-02-27: Por petición de Rizutto, el doble opt-in fue eliminado. Nadie del equipo web actual recomienda o aconseja este cambio.
            */
            $res = $client->request('POST', "https://us1.api.mailchimp.com/3.0/lists/{$list_id}/members", [
                'auth' => $credentials,
                'json' => [
                    'email_address' => (string) $request->EMAIL,
                    'status' => 'subscribed',
                    'merge_fields' => [
                        'FNAME' => (string) $request->FNAME,
                        'LNAME' => (string) $request->LNAME,
                        'BIRTHDAY' => (string) $request->BIRTHDAY,
                        'COUNTRY' => (string) $request->COUNTRY,
                        'STATE' => (string) $request->STATE,
                    ]
                ],
                'verify' => $verifySSL,
            ]);

            /* Ya toma el idioma ;) */
            return redirect()->back()->with('suscribe', __('newsletter.request-sent'));
        } catch (Exception $e) {
            $response = $e->getResponse()->getBody()->getContents();

            $response_decode = json_decode($response);
            
            /* Para hacer una comparación más flexible, el título es convertido a un slug (kebab-case) */
            if (Str::slug($response_decode->title, '-') == 'member-exists') {          
                return redirect()->back()->with('alert', __('newsletter.user-already-in'));
            } else {
                return redirect()->back()->with('alert', __('newsletter.server-failed-with-message') . $response_decode->title);
            }
        }
    }
}
