<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Frontend;

use AvengersMG\MGCms2019\App\Cms\Forms\Form;
use AvengersMG\MGCms2019\App\Cms\Forms\FormRequest;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use AvengersMG\MGCms2019\App\Mail\ReserveTours;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use phpDocumentor\Reflection\Types\This;

class FormsHandlerController extends Controller
{
    /**
     * Definición de RegEx para encontrar hipervínculos. Dominio público.
     * @var string
     */
    private $no_links_regex = '/(?i)\b((?:https?:\/\/|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:\'".,<>?«»“”‘’]))/im';

    /**
     * Definición de RegEx para permitir caracteres alfabéticos, espacios
     * y guiones
     * @var string
     */
    private $alpha_spaces_hyphens_regex = '/^[\pL\s\-]+$/u';

    public function __invoke(Request $request)
    {
        /* Cambiar idioma de la aplicación para retornar la traducción correcta de
           de las validaciones */
        app()->setLocale($request->lang);

        if (empty($request->form_id)) {
            return redirect()->back()->withErrors('Ups... Hay un problema, repórtalo al 322154584');
        }

        /*
            NOTA: No son todos los campos que están en las plantillas, pero
            son los más importantes
         */
        $request->validate(
            [
                'form_id' => [
                    'required',
                    'exists:forms,id',
                ],
                'comments' => [
                    'sometimes',
                    'nullable',
                    /* No hipervínculos */
                    'not_regex:' . $this->no_links_regex,
                ],
                'special_requirements' => [
                    'sometimes',
                    'nullable',
                    /* No hipervínculos */
                    'not_regex:' . $this->no_links_regex,
                ],
                'name' => [
                    'sometimes',
                    /* Sólo letras, espacios y guiones */
                    'regex:' . $this->alpha_spaces_hyphens_regex,
                ],
                'last_name' => [
                    'sometimes',
                    /* Sólo letras, espacios y guiones */
                    'regex:' . $this->alpha_spaces_hyphens_regex,
                ],
                'phone' => [
                    'sometimes',
                ],
                'email' => [
                    'sometimes',
                    'email',
                ],
                'adults' => [
                    'sometimes',
                    'integer',
                ],
                'children' => [
                    'sometimes',
                ],
                'zip_code' => [
                    'sometimes',
                    'alpha_num',
                ],
                'country' => [
                    'sometimes',
                    /* Sólo letras, espacios y guiones */
                    'regex:' . $this->alpha_spaces_hyphens_regex,
                ],
                'state' => [
                    'sometimes',
                    /* Sólo letras, espacios y guiones */
                    'regex:' . $this->alpha_spaces_hyphens_regex,
                ],
                'city' => [
                    'sometimes',
                    /* Sólo letras, espacios y guiones */
                    'regex:' . $this->alpha_spaces_hyphens_regex,
                ],
                'arrival_date' => [
                    'sometimes',
                    'date',
                ],
                'departure_date' => [
                    'sometimes',
                    'date',
                ],
            ],
            [
                'not_regex' => 'Please check that the information contains only text. No links or code are allowed.',
            ]
        );

        /* Validación pasó */

        $form = Form::findOrFail($request->form_id);
        $package_class = "AvengersMG\MGCms2019\App\Mail\\$form->handler";
        $project_class = "App\Mail\\$form->handler";

        /* Si existe, usar la clase definida en el proyecto */
        $class = class_exists($project_class) ? $project_class : $package_class;

        $folio = FormRequest::insertGetId(
            [
                'form_id' => $request->form_id,
                'status' => 0,
                'assigned' => json_encode($form->recipients[0][0]['email']),
                'locale'    => $request->lang,
                'created_at' => $request->created_at,
                'updated_at' => $request->updated_at
            ]
        );
if($form->debug == 0){
        /* TODO: Encontrar mejor forma de filtrar conducta especial */
        if (in_array($form->handler, ['ReserveTours', 'TransferMail', 'ReserveSpa', 'RestaurantMail'])) {
            $mailable = new $class($request, $folio) ;
            $mailable->replyTo($request->email, $request->name);
            if(count($form->recipients[1]) > 0){
                Mail::to($form->recipients[0])
                ->cc($request->email)
                ->bcc($form->recipients[1])
                ->send($mailable);
            }else{
                Mail::to($form->recipients[0])
                ->cc($request->email)
                ->send($mailable);
            }
        } else {
            if(count($form->recipients[1]) > 0){
                Mail::to($form->recipients[0])
                ->bcc($form->recipients[1])
                ->send(new $class($request, $folio));
            }else{
                Mail::to($form->recipients[0])
                ->send(new $class($request, $folio));
            }
        }
}else{
    // dd('debug');
    $recipientes = [
        [
            'email' => 'dev@marivalaccess.com',
            'name'  => 'developers'
        ]
    ];
    //dd($recipientes);
    $mailable = new $class($request, $folio) ;
    Mail::to($recipientes)
        ->send($mailable);
}

        if ($request->ajax()) {
            if ($request->lang == 'es')
                return response()->json('¡Formulario Enviado!');

            return response()->json('Form Sent!');
        }

        if ($request->lang == 'es') {
            return redirect()->back()->with('message', '¡Formulario Enviado!');
        } else {
            return redirect()->back()->with('message', 'Form Sent!');
        }
    }
}
