<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Frontend;

use AvengersMG\MGCms2019\App\Cms\Banners\Banner;
use Illuminate\Http\Request;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;

class BannersController extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke($lang)
    {
        $actives = Banner::select('id', 'priority')->translatedIn('es')->whereDate('end_date', '>=', date('Y-m-d'))->get();
        $actives->toArray();
        if ($actives->count() > 0) {
            $this->randomBanner($actives);
        }
    }


    public function randomBanner($banners)
    {
        $priority = [];
        foreach ($banners as $banner) {
            for ($i = 0; $i < $banner->priority; $i++) {
                array_push($priority, $banner->id);
            }
        }
    }
}
