<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Frontend;

use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;

class AssetsController extends Controller
{
    /**
     * Display the specified resource.
     *
     * @param  int  $asset  Dirección de recurso
     * @return \Illuminate\Http\Response
     */
    public function show($asset)
    {
        /* Acceso desde paquete */
        $assetPath = __DIR__ . '/../../../../public/cms/' . $asset;

        /* Acceso desde oficial */
        $publicPath = public_path() . '/cms/' . $asset;

        /* Revisar si existe en paquete */
        $assetExists = file_exists($assetPath);

        /* Revisar si existe en public */
        $publicExists = file_exists($publicPath);

        if ($publicExists || $assetExists) {
            /* Establecer definitivo. public como prioridad */
            $definitivePath = $publicExists? $publicPath : $assetPath;

            /* Obtener la extensión. File:mimeType() retorna "text/plain" para CSS y JavaScript, lo que debe arreglarse */
            $extension = File::extension($definitivePath);

            /* Enviar MIME correcto */
            switch ($extension) {
              case 'css':
                  $mime = 'text/css';
                  break;
              case 'js':
                  $mime = 'text/javascript';
                  break;
              case 'svg':
                  $mime = 'image/svg+xml';
                  break;
              default:
                  $mime = File::mimeType($definitivePath);
                  break;
            }

            /* Retornar respuesta archivo */
            return Response::make(File::get($definitivePath), 200)->header('Content-Type', $mime);
        }

        /* 404: File Not Found */
        return abort(404);
    }
}
