<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    /**
     * Método público para la respuesta automática de controladores hijos
     *
     * @param  mixed    $boolean  Objeto, booleano o variable que puede ser
     *                            evaluada como true o false
     * @param  mixed    $route    Dirección de ruta o arreglo con parámetros
     *                            de ruta
     * @param  string   $message  Mensaje a mostrar para el usuario
     * @return Response           Redirección a la ruta solicitada
     */
    public function responseController($boolean, $route, $message = "Ups. Algo salió mal")
    {
        /* Objeto de redirección, para uso futuro */
        $retorno = redirect();

        if ($boolean) {
            /* Permitir agregar arreglo con parámetros de ruteo */
            $retorno = (is_array($route))
                ? call_user_func_array([$retorno, 'route'], $route)
                : call_user_func([$retorno, 'route'], $route);

            /* Retornar redirección a ruta */
            return $retorno->withSuccess($message);
        }

        /* $boolean es false */
        return $retorno->back()->withSuccess($message);
    }

    /**
     *  Método protegido para redirigir con el erro de falta de sitio
     *
     * @return Response Redirección de falta de sitio
     */
    protected function responseNoSitesFound()
    {
        /* No existen sitios definidos */
        return redirect()->route('admin.index')->with('errors', ['No hay sitio web creado']);
    }
}
