<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Socialmedias;

use AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories\SocialmediaInterface;
use AvengersMG\MGCms2019\App\Cms\Socialmedias\Request\SocialmediaRequest;
use AvengersMG\MGCms2019\App\Cms\Socialmedias\Request\UpdateSocialmediaRequest;
use AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SocialmediasController extends Controller
{
    /**
     * [$socialmedia contiene el repositorio de redes sociales]
     * @var [variable protegida]
     */
    protected $socialmedia;
    public $view;
    /**
     * [__construct contructor de clase]
     * @param SocialmediaInterface $socialmedia contiene la inyección de SocialmediaInterface
     */
    public function __construct(SocialmediaInterface $socialmedia)
    {
        $this->socialmedia = $socialmedia;
        $this->view = 'MGCms2019::admin.socialmedias.';
    }
    /**
     *
     * @return Response Dirige a la vista index de redes sociales /admin/socialmedias
     */
    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Socialmedia::class);

        /* obtiene todas las redes sociales existentes */
        $socialmedias = $this->socialmedia->list();

        /* retorna la vista y envía los registros de redes sociales obtenidos en $socialmedias */
        return view($this->view.'index', compact('socialmedias'));
    }
    /**
     *
     * @return Response Retorna la vista de create
     */
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Socialmedia::class);

        return view($this->view.'create');
    }

    /**
     * [store Método de guardado de redes sociales]
     * @param  Request $request Contiene campos enviados desde la vista del formulario
     * @return Response          retorna la vista index de las redes sociales
     */
    public function store(SocialmediaRequest $request)
    {
        $return_route = 'socialmedias.index';

        /* Buscar la autorización */
        $this->authorize('create', Socialmedia::class);

        /* obtiene los datos del $request para ser creados en la db mediante el método create del repositorio de redes sociales SocialmediaRepository@create */
        $this->socialmedia->create($request);

        /* Si el usuario no tiene permiso de listar redes sociales, retornar a creación */
        if (Auth::user()->cant('viewAny', Socialmedia::class)) {
            $return_route = 'socialmedias.create';
        }

        return redirect()->route($return_route);
    }

    /**
     * edit método de edición de redes sociales
     * @param  Socialmedia $socialmedia Contiene el modelo de redes sociales
     * @return Response           retorna la vista de idición de registros y pasa el modelo de redes sociales a la vista */
    public function edit(Socialmedia $socialmedia)
    {
        /* Buscar la autorización */
        $this->authorize('update', $socialmedia);

        return view($this->view.'edit', compact('socialmedia'));
    }

    /**
     * update Método para la actualización de registros
     * @param  Request $request contiene la información de los campos del formulario de la vista
     * @param  Socialmedia $socialmedia contiene el modelo de la red social que se asigna al registro a ser actualizado
     * @return Response actualiza la red social mediante el método update del repositorio de redes sociales SocialmediaRepository@update
     */
    public function update(UpdateSocialmediaRequest $request, Socialmedia $socialmedia)
    {
        /* Buscar la autorización */
        $this->authorize('update', $socialmedia);

        $this->socialmedia->update($request, $socialmedia);

        /* Si el usuario no tiene permiso de listar redes sociales, retornar a edición */
        if (Auth::user()->cant('viewAny', Role::class)) {
            return redirect()->route('socialmedias.edit', $socialmedia->id);
        }

        /* Usuario puede retornar a listado de redes sociales */
        return redirect()->route('socialmedias.index');
    }
    /**
     * destroy método para eliminación de redes sociales
     * @param  Socialmedia $socialmedia Modelo de redes sociales para identifca el archivo que será eliminado
     * @return Response       Dirige a la vista index de redes sociales
     */
    public function destroy(Socialmedia $socialmedia)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $socialmedia);

        /* Elimina el dato corespondiente mediante el método de eloquent delete() */
        $socialmedia->delete();

        /* Retornar a la página original */
        return redirect()->back();
    }
}
