<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Sites;

use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use AvengersMG\MGCms2019\App\Cms\Sites\Repositories\SiteInterface;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories\SocialmediaInterface;
use Faker\Provider\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SitesController extends Controller
{
    protected $sites;
    protected $socialmedias;

    public function __construct(
        SiteInterface $site,
        SocialmediaInterface $socialmedia
    )
    {
        $this->sites = $site;
        $this->socialmedias = $socialmedia;
    }


    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Site::class);

        $sites = $this->sites->list();
        return view('MGCms2019::admin.sites.index', compact('sites'));
    }
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Site::class);

        return view('MGCms2019::admin.sites.create');
    }

    public function store(Request $request)
    {
        $return_route = 'sites.index';

        /* Buscar la autorización */
        $this->authorize('create', Site::class);

        $request->validate(['domain' => 'required|unique:sites,name']);
        $this->sites->createSite($request);

        $user = Auth::user();

        /* Si el usuario no puede listar sitios, redirigir a la página de creación */
        if ($user->cant('viewAny', Site::class)) {
            $return_route = 'sites.create';
        }

        return redirect()->route($return_route);
    }

    public function show(Site $site, $lang)
    {
        /* Buscar la autorización */
        $this->authorize('view', $site);

        app()->setLocale($lang);

        $themes = $this->sites->getThemes();
        $socialmedias = $this->socialmedias->all();

        /* Cargar redes sociales faltantes */
        $site->load(['socialmedias']);

        return view('MGCms2019::admin.sites.show', compact('site', 'lang', 'themes', 'socialmedias'));
    }

    public function update(Request $request, Site $site)
    {
        /* Buscar la autorización */
        $this->authorize('update', $site);

        $user = Auth::user();

        /* No permitir el cambio de dominio */
        if ($user->cant('updateDomain', Site::class) && $user->cant('updateOwnDomain', $site)) {
            $request->request->remove('domain');
        }

        $this->sites->updateSite($request, $site);

        return redirect()->route('sites.show', [$site, $request->lang]);
    }

    public function destroy(Site $site)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $site);

        //
    }
}
